-- Shared TXSE Exchange type definitions and enums used across protocols

local ExchangeTypes = {}

ExchangeTypes.price_decoder = function(buffer, pinfo, tree)
	local numeric = buffer(0, 8):le_uint64()
	tree:append_text(string.format(" $%0.4f", numeric:tonumber() / 100000000))
end

ExchangeTypes.Side = {
	[0] = "Buy",
	[1] = "Long Sell",
	[2] = "Short Sell",
	[3] = "Short Sell Exempt",
}

ExchangeTypes.TimeInForce = {
	[1] = "SYS",
	[2] = "IOC",
	[3] = "GTT",
	[4] = "DAY",
	[5] = "RHO",
}

ExchangeTypes.OrderCapacity = {
	[1] = "Agency",
	[2] = "Principal",
	[3] = "Riskless Principal",
}

ExchangeTypes.SelfMatchInstruction = {
	[0] = "No Self Match Prevention",
	[1] = "Cancel Newest",
	[2] = "Cancel Oldest",
	[3] = "Cancel Both",
	[4] = "Cancel Smallest",
	[5] = "Decrement and Cancel",
}

ExchangeTypes.SelfMatchScope = {
	[0] = "By Member",
	[1] = "By MPID",
	[2] = "By Member Group",
	[3] = "By MPID and Member Group",
}

ExchangeTypes.PriceSlideInstruction = {
	[0] = "No Price Slide",
	[1] = "Single Price Slide on Lock and Cross",
	[2] = "Multiple Price Slides on Lock and Cross",
	[3] = "Single Price Slide Lock Only",
}

ExchangeTypes.MarketHoursState = {
	[0] = "Closed Before Hours",
	[1] = "Early Session",
	[2] = "Regular Session",
	[3] = "After Hours Session",
	[4] = "Closed After Hours",
}

ExchangeTypes.SessionTradingState = {
	[0] = "Closed",
	[1] = "Trading",
	[2] = "Halted",
}

ExchangeTypes.SymbolTradingState = {
	[1] = "Trading",
	[2] = "Halted",
}

ExchangeTypes.ShortSaleRestrictionState = {
	[0] = "None",
	[1] = "Activated",
	[2] = "Continued",
}

ExchangeTypes.RejectReason = {
	[1] = "Invalid Client Order Id",
	[2] = "Duplicate Client Order Id",
	[3] = "Unknown Original Client Order Id",
	[4] = "No Longer On Book",
	[5] = "Invalid Symbol",
	[6] = "Invalid Price",
	[7] = "Invalid Order Quantity",
	[8] = "Invalid Reference Price Target",
	[9] = "Invalid Is Hidden Flag",
	[10] = "Invalid Order Type",
	[11] = "Invalid Side",
	[12] = "Invalid Max Floor Quantity",
	[13] = "Invalid Max Replenish Quantity Range",
	[14] = "Invalid Max Replenish Time Range",
	[15] = "Invalid Minimum Quantity",
	[16] = "Invalid Locate Required Flag",
	[17] = "Invalid Time In Force",
	[18] = "Unsupported Modification",
	[19] = "Invalid MPID",
	[20] = "Invalid Sender Comp",
	[21] = "Invalid Is Post Only Flag",
	[22] = "Invalid Expire Time",
	[23] = "Order Invalid for Trading Session",
	[24] = "Order Invalid for Trading Status",
	[25] = "Order Invalid for Symbol Status",
	[26] = "Invalid Is ISO Flag",
	[27] = "Trading Disabled for Port or MPID",
	[28] = "Trading Disabled for Non Test Symbols",
	[29] = "Trading Disabled for Order Capacity",
	[30] = "Trading Disabled for ISO",
	[31] = "Maximum Order Quantity Breached",
	[32] = "Maximum Price Breached",
	[33] = "Maximum Notional Breached",
}

ExchangeTypes.CancelReason = {
	[1] = "Requested by User",
	[2] = "Related to Time in Force",
	[3] = "Related to Min Qty",
	[4] = "NMS Violation No Slide",
	[5] = "Marketable Reserve",
	[6] = "Self Match Prevention",
	[7] = "Replenishment Canceled Due to Reserve",
	[8] = "Related to Order Type",
	[9] = "Canceled Due to Crossed Markets",
	[10] = "Canceled Due to Mass Cancel Request",
	[11] = "Exchange Locked and Crossed Violation No Slide",
}

ExchangeTypes.MarketConstraintAction = {
	[0] = "No Change",
	[1] = "Set",
	[2] = "Clear",
}

ExchangeTypes.OperationalHaltReason = {
	[0] = "Administrative",
}

ExchangeTypes.RegulatoryHaltReason = {
	[0] = "Reason Not Available",
	[1] = "News Pending",
	[2] = "News Dissemination",
	[3] = "Info Requested",
	[4] = "Order Imbalance",
	[5] = "Extraordinary Market Activity",
	[6] = "LULD Pause",
	[7] = "Non Compliance",
	[8] = "Filings Not Current",
	[9] = "SEC Suspension",
	[10] = "Regulatory Concern",
	[11] = "Sub Penny Trading",
	[12] = "ETF",
	[13] = "IPO Not Trading",
	[14] = "Corporate Action",
	[15] = "Circuit Breaker L1",
	[16] = "Circuit Breaker L2",
	[17] = "Circuit Breaker L3",
}

ExchangeTypes.CancelOnDisconnectInstruction = {
	[0] = "Disabled",
	[1] = "Enabled Cancel All",
}

ExchangeTypes.MassCancelScope = {
	[0] = "By Member Owned Sender Comps",
	[1] = "By Member Owned MPIDs",
}

ExchangeTypes.Instruction = {
	[1] = "Go Active",
	[2] = "Go Passive",
	[3] = "Snapshot State",
}

ExchangeTypes.MarketDataSource = {
	[1] = "Exchange",
	[2] = "SIP",
}

ExchangeTypes.OrderDisposition = {
	[0] = "Sprig Sent Disposition",
	[1] = "Resting Order",
	[2] = "No Resting Order",
}

ExchangeTypes.StateConflictReason = {
	[1] = "No Open Order Found",
	[2] = "No Replenishment Capacity",
	[3] = "Marketable Reserve",
	[4] = "Reprice Does Not Change Rank Price",
}

ExchangeTypes.RestatementReason = {
	[1] = "Reserve Replenished",
	[2] = "Repriced",
}

ExchangeTypes.ExchangeCode = {
	[1] = "TXSE",
	[2] = "XNAS",
	[3] = "XBOS",
	[4] = "XPSX",
	[5] = "EDGA",
	[6] = "EDGX",
	[7] = "BATY",
	[8] = "BATS",
	[9] = "MEMX",
	[10] = "EPRL",
	[11] = "LTSE",
	[12] = "IEXG",
	[13] = "XNYS",
	[14] = "ARCX",
	[15] = "XCIS",
	[16] = "XCHI",
	[17] = "XASE",
	[18] = "FINRA",
}

return ExchangeTypes
