local TXSE = require("txse-lib")
local ExchangeTypes = require("txse-exchange-types")

-- Use shared enums from ExchangeTypes module
local side_enum = ExchangeTypes.Side
local tif_enum = ExchangeTypes.TimeInForce
local capacity_enum = ExchangeTypes.OrderCapacity
local session_trading_state_enum = ExchangeTypes.SessionTradingState
local market_hours_state_enum = ExchangeTypes.MarketHoursState
local symbol_trading_state_enum = ExchangeTypes.SymbolTradingState
local operational_state_reason_enum = ExchangeTypes.OperationalHaltReason
local regulatory_halt_reason_enum = ExchangeTypes.RegulatoryHaltReason
local short_sale_restriction_state_enum = ExchangeTypes.ShortSaleRestrictionState
local restatement_reason_enum = ExchangeTypes.RestatementReason
local smp_scope_enum = ExchangeTypes.SelfMatchScope
local smp_instruction_enum = ExchangeTypes.SelfMatchInstruction
local reject_reason_enum = ExchangeTypes.RejectReason
local cancel_reason_enum = ExchangeTypes.CancelReason
local price_slide_instruction_enum = ExchangeTypes.PriceSlideInstruction
local mass_cancel_scope_enum = ExchangeTypes.MassCancelScope

-- Use shared price decoder from ExchangeTypes
local price_decoder = ExchangeTypes.price_decoder

local fields = {
    msg_type = {
        length = 1,
        abbr = "txse_seed.msg_type",
        name = "Message Type",
        ftype = ftypes.CHAR,
        encoding = ENC_ASCII,
    },
    matching_engine_id = {
        length = 1,
        abbr = "txse_seed.matching_engine_id",
        name = "Matching Engine Id",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
    },
    transact_time = {
        length = 8,
        abbr = "txse_seed.transact_time",
        name = "Transact Time",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    order_id = {
        length = 8,
        abbr = "txse_seed.order_id",
        name = "Order Id",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    limit_order_presence = {
        length = 4,
        abbr = "txse_seed.limit_order_presence",
        name = "Presence Bits",
        ftype = ftypes.BYTES,
        encoding = ENC_NA,
        is_presence_field = true,
    },
    market_order_presence = {
        length = 2,
        abbr = "txse_seed.market_order_presence",
        name = "Presence Bits",
        ftype = ftypes.BYTES,
        encoding = ENC_NA,
        is_presence_field = true,
    },
    modify_order_presence = {
        length = 1,
        abbr = "txse_seed.modify_order_presence",
        name = "Presence Bits",
        ftype = ftypes.BYTES,
        encoding = ENC_NA,
        is_presence_field = true,
    },
    replace_order_presence = {
        length = 2,
        abbr = "txse_seed.replace_order_presence",
        name = "Presence Bits",
        ftype = ftypes.BYTES,
        encoding = ENC_NA,
        is_presence_field = true,
    },
    mass_cancel_presence = {
        length = 1,
        abbr = "txse_seed.mass_cancel_presence",
        name = "Presence Bits",
        ftype = ftypes.BYTES,
        encoding = ENC_NA,
        is_presence_field = true,
    },
    restated_presence = {
        length = 1,
        abbr = "txse_seed.restated_presence",
        name = "Presence Bits",
        ftype = ftypes.BYTES,
        encoding = ENC_NA,
        is_presence_field = true,
    },
    trading_session_status_presence = {
        length = 1,
        abbr = "txse_seed.trading_session_status_presence",
        name = "Presence Bits",
        ftype = ftypes.BYTES,
        encoding = ENC_NA,
        is_presence_field = true,
    },
    symbol_status_presence = {
        length = 1,
        abbr = "txse_seed.symbol_status_presence",
        name = "Presence Bits",
        ftype = ftypes.BYTES,
        encoding = ENC_NA,
        is_presence_field = true,
    },
    clordid = {
        length = 8,
        abbr = "txse_seed.clordid",
        name = "Client Order Id",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    orig_clordid = {
        length = 8,
        abbr = "txse_seed.orig_clordid",
        name = "Original Client Order Id",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    quantity = {
        length = 4,
        abbr = "txse_seed.quantity",
        name = "Quantity",
        ftype = ftypes.INT32,
        encoding = ENC_LITTLE_ENDIAN,
    },
    exec_id = {
        length = 8,
        abbr = "txse_seed.exec_id",
        name = "Execution Id",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    exec_quantity = {
        length = 4,
        abbr = "txse_seed.exec_quantity",
        name = "Executed Quantity",
        ftype = ftypes.INT32,
        encoding = ENC_LITTLE_ENDIAN,
    },
    leaves_quantity = {
        length = 4,
        abbr = "txse_seed.leaves_quantity",
        name = "Leaves Quantity",
        ftype = ftypes.INT32,
        encoding = ENC_LITTLE_ENDIAN,
    },
    limit_order_bit_fields = {
        length = 4,
        abbr = "txse_seed.limit_order_bit_fields",
        name = "Bit Fields",
        ftype = ftypes.INT32,
        encoding = ENC_LITTLE_ENDIAN,
        custom_decode = function(buffer, pinfo, tree)
            local numeric = buffer(0, 4):le_uint()
            local side = TXSE.extract_bits(numeric, 0, 3)
            tree:add(buffer, string.format("Side: %d (%s)", side, side_enum[side] or "Unknown"))
            tree:add(buffer, string.format("Locate Required: %d", TXSE.extract_bits(numeric, 3, 1)))
            local tif = TXSE.extract_bits(numeric, 4, 4)
            tree:add(buffer, string.format("TIF: %d (%s)", tif, tif_enum[tif] or "Unknown"))
            local capacity = TXSE.extract_bits(numeric, 8, 3)
            tree:add(buffer, string.format("Capacity: %d (%s)", capacity, capacity_enum[capacity] or "Unknown"))
            tree:add(buffer, string.format("Is ISO: %d", TXSE.extract_bits(numeric, 11)))
            tree:add(buffer, string.format("Is Hidden: %d", TXSE.extract_bits(numeric, 12)))
            tree:add(buffer, string.format("Is Post Only: %d", TXSE.extract_bits(numeric, 13)))
            tree:add(buffer, string.format("Cancel At Entry if Crossed Markets: %d", TXSE.extract_bits(numeric, 14)))
        end,
    },
    market_order_bit_fields = {
        length = 2,
        abbr = "txse_seed.market_order_bit_fields",
        name = "Bit Fields",
        ftype = ftypes.INT16,
        encoding = ENC_LITTLE_ENDIAN,
        custom_decode = function(buffer, pinfo, tree)
            local numeric = buffer(0, 2):le_uint()
            local side = TXSE.extract_bits(numeric, 0, 3)
            tree:add(buffer, string.format("Side: %d (%s)", side, side_enum[side] or "Unknown"))
            tree:add(buffer, string.format("Locate Required: %d", TXSE.extract_bits(numeric, 3, 1)))
            local tif = TXSE.extract_bits(numeric, 4, 4)
            tree:add(buffer, string.format("TIF: %d (%s)", tif, tif_enum[tif] or "Unknown"))
            local capacity = TXSE.extract_bits(numeric, 8, 3)
            tree:add(buffer, string.format("Capacity: %d (%s)", capacity, capacity_enum[capacity] or "Unknown"))
        end,
    },
    modify_order_bit_fields = {
        length = 1,
        abbr = "txse_seed.modify_order_bit_fields",
        name = "Bit Fields",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        custom_decode = function(buffer, pinfo, tree)
            local numeric = buffer(0, 1):le_uint()
            local side = TXSE.extract_bits(numeric, 0, 3)
            tree:add(buffer, string.format("Side: %d (%s)", side, side_enum[side] or "Unknown"))
            tree:add(buffer, string.format("Locate Required: %d", TXSE.extract_bits(numeric, 3, 1)))
        end,
    },
    replace_order_bit_fields = {
        length = 2,
        abbr = "txse_seed.modify_order_bit_fields",
        name = "Bit Fields",
        ftype = ftypes.INT16,
        encoding = ENC_NA,
        custom_decode = function(buffer, pinfo, tree)
            local numeric = buffer(0, 2):le_uint()
            local side = TXSE.extract_bits(numeric, 0, 3)
            tree:add(buffer, string.format("Side: %d (%s)", side, side_enum[side] or "Unknown"))
            tree:add(buffer, string.format("Locate Required: %d", TXSE.extract_bits(numeric, 3, 1)))
            tree:add(buffer, string.format("Is ISO: %d", TXSE.extract_bits(numeric, 4, 1)))
            tree:add(buffer, string.format("Is Post Only: %d", TXSE.extract_bits(numeric, 5, 1)))
            tree:add(buffer, string.format("Cancel At Entry if Crossed Markets: %d", TXSE.extract_bits(numeric, 6, 1)))
        end,
    },
    define_symbol_bit_fields = {
        length = 1,
        abbr = "txse_seed.define_symbol_bit_fields",
        name = "Bit Fields",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        custom_decode = function(buffer, pinfo, tree)
            local numeric = buffer(0, 1):le_uint()
            local is_test = TXSE.extract_bits(numeric, 0)
            tree:add(buffer, string.format("Is Test: %d", is_test))
        end,
    },
    symbol_id = {
        length = 2,
        abbr = "txse_seed.symbol_id",
        name = "Symbol ID",
        ftype = ftypes.INT16,
        encoding = ENC_LITTLE_ENDIAN,
    },
    price = {
        length = 8,
        abbr = "txse_seed.price",
        name = "Price",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
        custom_decode = price_decoder,
    },
    rank_price = {
        length = 8,
        abbr = "txse_seed.rank_price",
        name = "Rank Price",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
        custom_decode = price_decoder,
    },
    display_price = {
        length = 8,
        abbr = "txse_seed.display_price",
        name = "Display Price",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
        custom_decode = price_decoder,
    },
    restatement_reason = {
        length = 1,
        abbr = "txse_seed.restatement_reason",
        name = "Restatement Reason",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = restatement_reason_enum,
    },
    smp_scope = {
        length = 1,
        abbr = "txse_seed.smp_scope",
        name = "Self-Match Prevention Scope",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = smp_scope_enum,
    },
    smp_instruction = {
        length = 1,
        abbr = "txse_seed.smp_instruction",
        name = "Self-Match Prevention Instruction",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = smp_instruction_enum,
    },
    reject_reason = {
        length = 1,
        abbr = "txse_seed.reject_reason",
        name = "Reject Reason",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = reject_reason_enum,
    },
    cancel_reason = {
        length = 1,
        abbr = "txse_seed.cancel_reason",
        name = "Cancel Reason",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = cancel_reason_enum,
    },
    session_trading_state = {
        length = 1,
        abbr = "txse_seed.session_trading_state",
        name = "Session Trading State",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = session_trading_state_enum,
    },
    price_slide_instruction = {
        length = 1,
        abbr = "txse_seed.price_slide_instruction",
        name = "Price Slide Instruction",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = price_slide_instruction_enum,
    },
    mass_cancel_scope = {
        length = 1,
        abbr = "txse_seed.mass_cancel_scope",
        name = "Scope",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = mass_cancel_scope_enum,
    },
    min_qty = {
        length = 4,
        abbr = "txse_seed.min_qty",
        name = "Min Quantity",
        ftype = ftypes.INT32,
        encoding = ENC_LITTLE_ENDIAN,
    },
    max_floor_qty = {
        length = 4,
        abbr = "txse_seed.max_floor_qty",
        name = "Max Floor Quantity",
        ftype = ftypes.INT32,
        encoding = ENC_LITTLE_ENDIAN,
    },
    max_replenish_qty_range = {
        length = 4,
        abbr = "txse_seed.max_replenish_qty_range",
        name = "Max Replenish Quantity Range",
        ftype = ftypes.INT32,
        encoding = ENC_LITTLE_ENDIAN,
    },
    max_replenish_time_range = {
        length = 8,
        abbr = "txse_seed.max_replenish_time_range",
        name = "Max Replenish Time Range",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    reference_price_target = {
        length = 2,
        abbr = "txse_seed.reference_price_target",
        name = "Reference Price Target",
        ftype = ftypes.INT16,
        encoding = ENC_LITTLE_ENDIAN,
        custom_decode = function(buffer, pinfo, tree)
            local bps = buffer:le_uint()
            tree:append_text(string.format(" bps or %0.2f%%", bps / 100.0))
        end
    },
    expire_time = {
        length = 8,
        abbr = "txse_seed.expire_time",
        name = "Expire Time",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    mass_cancel_request_id = {
        length = 8,
        abbr = "txse_seed.mass_cancel_request_id",
        name = "Mass Cancel Request Id",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    user_data = {
        length = 8,
        abbr = "txse_seed.user_data",
        name = "User Data",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    mass_cancel_id = {
        length = 8,
        abbr = "txse_seed.mass_cancel_id",
        name = "Mass Cancel Id",
        ftype = ftypes.INT64,
        encoding = ENC_LITTLE_ENDIAN,
    },
    canceled_count = {
        length = 4,
        abbr = "txse_seed.canceled_count",
        name = "Canceled Count",
        ftype = ftypes.INT32,
        encoding = ENC_LITTLE_ENDIAN,
    },
    mpid = {
        length = 4,
        abbr = "txse_seed.mpid",
        name = "MPID",
        ftype = ftypes.STRING,
        encoding = ENC_ASCII,
    },
    sender_comp = {
        length = 8,
        abbr = "txse_seed.sender_comp",
        name = "Sender Comp",
        ftype = ftypes.STRING,
        encoding = ENC_ASCII,
    },
    member_group = {
        length = 2,
        abbr = "txse_seed.member_group",
        name = "Member Group",
        ftype = ftypes.STRING,
        encoding = ENC_ASCII,
    },
    locate_broker = {
        length = 4,
        abbr = "txse_seed.locate_broker",
        name = "Locate Broker",
        ftype = ftypes.STRING,
        encoding = ENC_ASCII,
    },
    symbol_root = {
        length = 8,
        abbr = "txse_seed.symbol_root",
        name = "CMS Symbol Root",
        ftype = ftypes.STRING,
        encoding = ENC_ASCII,
    },
    symbol_suffix = {
        length = 8,
        abbr = "txse_seed.symbol_suffix",
        name = "CMS Symbol Suffix",
        ftype = ftypes.STRING,
        encoding = ENC_ASCII,
    },
    lot_size = {
        length = 4,
        abbr = "txse_seed.lot_size",
        name = "Round Lot Size",
        ftype = ftypes.INT16,
        encoding = ENC_LITTLE_ENDIAN,
    },
    market_hours_state = {
        length = 1,
        abbr = "txse_seed.market_hours_state",
        name = "Market Hours State",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = market_hours_state_enum,
    },
    operational_halt_reason = {
        length = 1,
        abbr = "txse_seed.operational_halt_reason",
        name = "Operational Halt Reason",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = operational_state_reason_enum,
    },
    regulatory_halt_reason = {
        length = 1,
        abbr = "txse_seed.regulatory_halt_reason",
        name = "Regulatory Halt Reason",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = regulatory_halt_reason_enum,
    },
    symbol_trading_state = {
        length = 1,
        abbr = "txse_seed.symbol_trading_state",
        name = "Symbol Trading State",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = symbol_trading_state_enum,
    },
    ssr_state = {
        length = 1,
        abbr = "txse_seed.ssr_state",
        name = "Short Sale Restriction State",
        ftype = ftypes.INT8,
        encoding = ENC_NA,
        value_map = short_sale_restriction_state_enum,
    },
}

return {
    side_enum = side_enum,
    tif_enum = tif_enum,
    capacity_enum = capacity_enum,
    fields = fields,
}
