<?php

/**
 * Upgrade script to version 2.1.0
 * This script deregisters the displayPaymentTop or paymentTop hook if theCheckout module is active and registers displayCmHeurekaConsent.
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_2_1_0($module)
{
	$theCheckout = Module::getInstanceByName('thecheckout');

	if (Validate::isLoadedObject($theCheckout) && $theCheckout->active) {
		if(version_compare(_PS_VERSION_, '1.7', '>=')) {
			if ( Hook::getIdByName( 'displayPaymentTop' ) ) {
				if ( ! $module->unregisterHook( 'displayPaymentTop' ) ) {
					return false;
				}
			}
		}else {
			if ( Hook::getIdByName( 'paymentTop' ) ) {
				if ( ! $module->unregisterHook( 'paymentTop' ) ) {
					return false;
				}
			}
		}

		$module->registerHook('displayCmHeurekaConsent');
	}

    return true;
}
