document.addEventListener('DOMContentLoaded', function() {
    // Initial setup on page load
    applyVisibilityRules();
    
    // Attach event listeners
    document.getElementById('MONTONIO_PAYMENTS_STYLE').addEventListener('change', applyVisibilityRules);
    document.getElementById('MONTONIO_BNPL_STYLE').addEventListener('change', applyVisibilityRules);

    // Get all the radio buttons and attach event listeners
    var radios = document.querySelectorAll('input[type="radio"][name^="MONTONIO_PAYMENTS"], input[type="radio"][name^="MONTONIO_CARD"], input[type="radio"][name^="MONTONIO_BLIK"], input[type="radio"][name^="MONTONIO_BNPL"], input[type="radio"][name^="MONTONIO_FINANCING"]');
    radios.forEach(function(radio) {
        radio.addEventListener('change', applyVisibilityRules);
    });

    // Create sortable list for payment methods order
    createPaymentMethodOrderSortable();
});

$(document).ready(function() {
    $('.swap-custom-container').each(function () {
        if (typeof $('.addSwap', this) !== undefined && typeof $(".removeSwap", this) !== undefined &&
            typeof $('.selectedSwap', this) !== undefined && typeof $('.availableSwap', this) !== undefined) {
            bindSwapButtonCustom('add', 'available', 'remove', 'selected', this);
            bindSwapButtonCustom('remove', 'selected', 'add', 'available', this);
            doubleClickOptionCustom('add', 'available', this);
            doubleClickOptionCustom('remove', 'selected', this);
        }
    });

    $('form').submit(function() {
        $('.availableSwap').each(function() {
            $(this).find('option').each(function() {
                $(this).prop('selected', false);
            });
        });

        $('.selectedSwap').each(function() {
            $(this).find('option').each(function() {
                $(this).prop('selected', true);
            });
        });
        console.log('works');
    });
});

function doubleClickOptionCustom(from_button, prefix_select, context) {
    $('.' + prefix_select + 'Swap option', context).on('click', function() {
        $(this).dblclick(function() {
            $('.'+from_button+'Swap', context).click();
        })
    });
}

function bindSwapButtonCustom(from_button, from_select, to_button, to_select, context) {
    $('.'+from_button+'Swap', context).on('click', function(e) {
        e.preventDefault();
        $('.' + from_select + 'Swap option:selected', context).each(function() {
            var to = $('.' + to_select + 'Swap', context);
            var from = $('.' + from_select + 'Swap', context);

            var selected = from.find('option:selected');
            var selectedVal = [];
            selected.each(function(){
                selectedVal.push($(this).val());
            });

            var options = from.data('options');
            var tempOption = [];
            var targetOptions = to.data('options');

            $.each(options, function(i) {
                var option = options[i];
                if($.inArray(option.value, selectedVal) == -1) {
                    tempOption.push(option);
                } else {
                    targetOptions.push(option);
                }
            });

            to.find('option:selected').prop('selected', false);
            from.find('option:selected').remove().appendTo(to).prop('selected', true);

            to.data('options', targetOptions);
            from.data('options', tempOption);

            to.html(to.find('option').sort(function(x, y) {
                if (isNaN($(x).data('sort')) || isNaN($(y).data('sort'))) {
                    return $(x).data('sort') > $(y).data('sort') ? 1 : -1;
                } else {
                    return $(x).data('sort') - $(y).data('sort');
                }
            }));

        });

        $('.' + to_select + 'Swap option', context).on('click', function() {
            $(this)[0].ondblclick = function(){
                $('.'+to_button+'Swap', context).click();
            };
        });
    });
}

function applyVisibilityRules() {
    var isPaymentsEnabled = document.querySelector('input[name="MONTONIO_PAYMENTS_ENABLED"]:checked').value === '1';
    var isCardEnabled = document.querySelector('input[name="MONTONIO_CARD_PAYMENTS_ENABLED"]:checked').value === '1';
    var isBlikEnabled = document.querySelector('input[name="MONTONIO_BLIK_ENABLED"]:checked').value === '1';
    var isBnplEnabled = document.querySelector('input[name="MONTONIO_BNPL_ENABLED"]:checked').value === '1';
    var isFinancingEnabled = document.querySelector('input[name="MONTONIO_FINANCING_ENABLED"]:checked').value === '1';
    var checkoutStyle = document.getElementById('MONTONIO_PAYMENTS_STYLE').value;
    var bnplStyle = document.getElementById('MONTONIO_BNPL_STYLE').value;

    var visibilityRules = {
        // Montonio Bank Payments
        'MONTONIO_PAYMENTS_STYLE': isPaymentsEnabled,
        'MONTONIO_PAYMENTS_DISPLAY_NAME_MODE': isPaymentsEnabled,
        'MONTONIO_PAYMENTS_SHOW_LOGO': isPaymentsEnabled,
        'MONTONIO_PAYMENTS_HIDE_COUNTRY': isPaymentsEnabled && checkoutStyle === 'banklist',
        'MONTONIO_PAYMENTS_DEFAULT_COUNTRY': isPaymentsEnabled && checkoutStyle === 'banklist',
        'MONTONIO_PAYMENTS_AUTOMATICALLY_CHANGE_COUNTRY': isPaymentsEnabled && checkoutStyle === 'banklist',
        'MONTONIO_PAYMENTS_AUTOMATICALLY_SELECT_METHOD': isPaymentsEnabled && checkoutStyle === 'banklist',
        'MONTONIO_PAYMENTS_TRANSLATE_COUNTRY_DROPDOWN': isPaymentsEnabled && checkoutStyle === 'banklist',
        'MONTONIO_PAYMENTS_EXCLUDED_CURRENCIES': isPaymentsEnabled,

        // Montonio Card Payments
        'MONTONIO_CARD_PAYMENTS_SHOW_LOGO': isCardEnabled,
        'MONTONIO_CARD_PAYMENTS_IN_CHECKOUT': isCardEnabled,
        'MONTONIO_CARD_EXCLUDED_CURRENCIES': isCardEnabled,

        // Montonio BLIK
        'MONTONIO_BLIK_SHOW_LOGO': isBlikEnabled,
        'MONTONIO_BLIK_IN_CHECKOUT': isBlikEnabled,
        'MONTONIO_BLIK_EXCLUDED_CURRENCIES': isBlikEnabled,

        // Montonio BNPL
        'MONTONIO_BNPL_STYLE': isBnplEnabled,
        'MONTONIO_BNPL_SHOW_LOGO': isBnplEnabled,
        'MONTONIO_BNPL_GRAND_TOTAL_MIN': isBnplEnabled,
        'MONTONIO_BNPL_GRAND_TOTAL_MAX': isBnplEnabled,
        'MONTONIO_BNPL_EXCLUDED_CURRENCIES': isBnplEnabled,

        // Montonio Financing
        'MONTONIO_FINANCING_SHOW_LOGO': isFinancingEnabled,
        'MONTONIO_FINANCING_GRAND_TOTAL_MIN': isFinancingEnabled,
        'MONTONIO_FINANCING_GRAND_TOTAL_MAX': isFinancingEnabled,
        'MONTONIO_FINANCING_EXCLUDED_CURRENCIES': isFinancingEnabled,
    };

    for (var key in visibilityRules) {
        var element = document.getElementById(key) || document.getElementsByName(key)[0];
        if (element) {
            element.closest('.form-group').style.display = visibilityRules[key] ? 'block' : 'none';
        }
    }
}

function createPaymentMethodOrderSortable() {
    var list = $('#montonio-payment-methods-order');
    var sortInput = $('#MONTONIO_PAYMENT_METHODS_ORDER');

    var fnSubmit = function(){
        var sortOrder = [];
        list.children('li').each(function(){
            sortOrder.push($(this).data('id'));
        });

        sortInput.val(sortOrder.join(','));
    };

    /* store values */
    list.children('li').each(function() {
          var li = $(this);
  
        //store value and clear title value
        li.data('id',li.attr('data-method')).attr('data-method','');
    });

    /* sortables */
    list.sortable({
      opacity: 0.7,
      update: function() {
        fnSubmit();
      }
    });

}