{extends file="helpers/form/form.tpl"}
{block name="field"}
    {if $input.type == 'swap-custom'}
        <div class="col-lg-8 bootstrap margin-group panel swap-custom">
            <div class="swap-custom-container row">
                <div class="col-lg-12">
                    <div class="form-control-static row">
                        <div class="col-xs-6">
                            <label for="{$input.name|escape:'html':'UTF-8'}_available[]">{l s='Enabled currencies' mod='montonio'}</label>
                            <select {if isset($input.size)}size="{$input.size|escape:'html':'UTF-8'}"{/if}{if isset($input.onchange)} onchange="{$input.onchange|escape:'html':'UTF-8'}"{/if} class="{if isset($input.class)}{$input.class|escape:'html':'UTF-8'}{/if} availableSwap" name="{$input.name|escape:'html':'UTF-8'}_available[]" multiple="multiple">
                                {foreach $input.options.query AS $option}
                                    {if is_object($option)}
                                        {assign var=option value=$option->arrContent}
                                    {/if}
                                    {if !is_array($fields_value[$input.name|cat:'[]']) || !in_array($option[$input.options.name|escape:'html':'UTF-8'], $fields_value[$input.name|cat:'[]']) }
                                        <option value="{$option[$input.options.id|escape:'html':'UTF-8']}">{$option[$input.options.name|escape:'html':'UTF-8']}</option>
                                    {elseif $option == "-"}
                                        <option value="">-</option>
                                    {/if}
                                {/foreach}
                            </select>
                            <a href="#" class="btn btn-default btn-block addSwap">{l s='Add' d='Admin.Actions'} <i class="icon-arrow-right"></i></a>
                        </div>
                        <div class="col-xs-6">
                            <label for="{$input.name|escape:'html':'UTF-8'}[]">{l s='Disabled currencies' mod='montonio'}</label>
                            <select {if isset($input.size)}size="{$input.size|escape:'html':'UTF-8'}"{/if}{if isset($input.onchange)} onchange="{$input.onchange|escape:'html':'UTF-8'}"{/if} class="{if isset($input.class)}{$input.class|escape:'html':'UTF-8'}{/if} selectedSwap" name="{$input.name|escape:'html':'UTF-8'}[]" multiple="multiple">
                                {foreach $input.options.query AS $option}
                                    {if is_object($option)}
                                        {assign var=option value=$option->arrContent}
                                    {/if}
                                    {if is_array($fields_value[$input.name|cat:'[]']) && in_array($option[$input.options.name|escape:'html':'UTF-8'], $fields_value[$input.name|cat:'[]']) }
                                        <option value="{$option[$input.options.id|escape:'html':'UTF-8']}">{$option[$input.options.name|escape:'html':'UTF-8']}</option>
                                    {elseif $option == "-"}
                                        <option value="">-</option>
                                    {/if}
                                {/foreach}
                            </select>
                            <a href="#" class="btn btn-default btn-block removeSwap"><i class="icon-arrow-left"></i> {l s='Remove' mod='montonio'}</a>
                        </div>
                    </div>
                </div>
                {if isset($input['desc']) && !empty($input['desc'])}
                    <div class="col-lg-12">
                        <div class="help-block">
                            {if is_array($input['desc'])}
                                {foreach $input['desc'] as $p}
                                    {if is_array($p)}
                                        <span id="{$p.id|intval}">{$p.text nofilter}</span><br />
                                    {else}
                                        {$p nofilter}<br />
                                    {/if}
                                {/foreach}
                            {else}
                                {$input['desc'] nofilter}
                            {/if}
                        </div>
                    </div>
                {/if}
            </div>
        </div>
        {if version_compare($smarty.const._PS_VERSION_,'1.6','<')}
            <div class="clear">&nbsp;</div>
        {/if}
    {else}
        {$smarty.block.parent}
    {/if}
{/block}
