<form class="montonio-payment-method-form" method="POST" action="{$montonio_embedded_form_action}" id="{$montonio_embedded_form_id}" data-method-name="{$montonio_embedded_method_name}">
    <div id="{$montonio_embedded_form_id}-target"></div>
    {if $montonio_embedded_form_submit_text}
        <button type="submit" class="button btn btn-default button-medium button-submit-payment">
            <span>{$montonio_embedded_form_submit_text}<i class="icon-chevron-right right"></i></span>
        </button>
    {/if}
</form>

<script>
    window.montonioLoadQueue = window.montonioLoadQueue || [];
    window.montonioLoadQueue.push(function() {
        var targetElement = document.getElementById('{$montonio_embedded_form_id}-target');
        if (targetElement && targetElement.querySelector('iframe') !== null)
            return false;

        window.embeddedPayment = new MontonioLegacy.Checkout.Blik({
            locale: "{$montonio_embedded_locale}",
            environment: "{if $montonio_embedded_is_sandbox}sandbox{else}production{/if}",
            targetElement: document.getElementById("{$montonio_embedded_form_id}-target"),
        });

        window.embeddedPayment.render();

        montonioInterceptBlinkFormSubmissions();
        ensureMontonioBlikCompatibility();

        var observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                montonioInterceptBlinkFormSubmissions();
                ensureMontonioBlikCompatibility();
            });
        });
        observer.observe(document.body, { childList: true, subtree: true });
    });

    function montonioInterceptBlinkFormSubmissions() {
        var forms = document.querySelectorAll('#{$montonio_embedded_form_id}');
        for (var i = 0; i < forms.length; i++) {
            var form = forms[i];
            if (form._montonioSubmitInterceptorRegistered) {
                continue;
            }

            form.addEventListener('submit', function (event) {
                handleBlinkSubmission(event, this);
            });
            form.submit = function (event) {
                handleBlinkSubmission(event, this);
            };

            form._montonioSubmitInterceptorRegistered = true;
        }
    }

    function handleBlinkSubmission(event, form){
        if (event && event.preventDefault) {
            event.preventDefault();
        }

        if (form.closest('.velsof_content_section')) { //compatability for supercheckout
            document.querySelector('.opc_payment_method #{$montonio_embedded_form_id}').submit();
            return true;
        }

        window.embeddedPayment.showModal();

        window.embeddedPayment
            .validate()
            .then(function (isValid) {
                if (!isValid) {
                    return setMontonioErrors('BLIK_ER_WRONG_TICKET');
                }

                var formData = new FormData(form);
                var xhr = new XMLHttpRequest();
                xhr.open(form.method, form.action, true);
                xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                xhr.onreadystatechange = function() {
                    if (xhr.readyState !== 4 || xhr.status !== 200) {
                        return;
                    }

                    var response = JSON.parse(xhr.responseText);
                    if (!response.success || !response.puuid) {
                        return setMontonioErrors('BLIK_ER_WRONG_TICKET');
                    }

                    var paymentIntentUuid = response.puuid;

                    window.embeddedPayment.waitForPayment(paymentIntentUuid)
                        .then(response => {
                            window.location.replace(response.merchantReturnUrl);
                        })
                        .catch(error => {
                            return setMontonioErrors(error);
                        });
                };

                xhr.send(formData);
            })
            .catch(function () {
                return setMontonioErrors('BLIK_ER_WRONG_TICKET');
            });
    }

    function setMontonioErrors(errors) {
        var montonioErrorControllerBaseUrl = '{$montonio_embedded_error_controller_url}';
        var errorUrl = montonioErrorControllerBaseUrl + '?montonio_errors=' + encodeURIComponent(errors);

        window.location.replace(errorUrl);
    }

    function ensureMontonioBlikCompatibility() { //compatability for theCheckout
        if (!window.originalUpdatePaymentBlock && typeof updatePaymentBlock !== 'undefined') {
            window.originalUpdatePaymentBlock = updatePaymentBlock;
        }

        window.updatePaymentBlock = function(paymentModulesList, html, checksum, triggerElementName) {
            try {
                // Get the selected payment option's module name
                var selectedOption = payment.getSelectedOptionModuleName();

                // Return early if selectedOption contains "montonio"
                if (selectedOption && selectedOption.includes("montonio")) {
                    return;
                }

                // Otherwise, call the original function
                return window.originalUpdatePaymentBlock(paymentModulesList, html, checksum, triggerElementName);

            } catch (error) {
                // If an error occurs, fallback to the original implementation
                return window.originalUpdatePaymentBlock(paymentModulesList, html, checksum, triggerElementName);
            }
        };
    }

</script>