( function ( $ ) {
	const fieldsets = $( '.mrb-pb-fieldset' );
	const typeField = $( '#mrb-pb-type' );

	if ( typeField.length && fieldsets.length ) {
		const toggleFieldsets = () => {
			const currentType = typeField.val();

			fieldsets.each( function () {
				const $fieldset = $( this );
				const type = $fieldset.data( 'type' );

				$fieldset.toggleClass( 'is-active', type === currentType );
			} );
		};

		typeField.on( 'change', toggleFieldsets );
		toggleFieldsets();
	}

	let frame = null;
	const selectBtn = $( '#mrb-pb-select-image' );
	const removeBtn = $( '#mrb-pb-remove-image' );

	if ( selectBtn.length ) {
		selectBtn.on( 'click', function ( e ) {
			e.preventDefault();

			if ( frame ) {
				frame.open();
				return;
			}

			frame = wp.media( {
				title: MRBPBAdmin.mediaTitle,
				button: { text: MRBPBAdmin.mediaButton },
				multiple: false,
			} );

			frame.on( 'select', function () {
				const attachment = frame.state().get( 'selection' ).first().toJSON();

				$( '#mrb-pb-image-id' ).val( attachment.id );
				$( '#mrb-pb-image-url' ).val( attachment.url );
				$( '#mrb-pb-image-preview' ).html( `<img src="${ attachment.url }" alt="" />` );
			} );

			frame.open();
		} );
	}

	if ( removeBtn.length ) {
		removeBtn.on( 'click', function ( e ) {
			e.preventDefault();

			$( '#mrb-pb-image-id' ).val( '' );
			$( '#mrb-pb-image-url' ).val( '' );
			$( '#mrb-pb-image-preview' ).empty();
		} );
	}

	const colorFields = $( '.mrb-pb-color-field' );

	if ( colorFields.length && $.fn.wpColorPicker ) {
		colorFields.wpColorPicker();
	}

	// Bulk actions - select all checkbox
	const selectAll = $( '#mrb-pb-select-all' );
	const badgeCheckboxes = $( '.mrb-pb-badge-checkbox' );

	if ( selectAll.length && badgeCheckboxes.length ) {
		selectAll.on( 'change', function () {
			badgeCheckboxes.prop( 'checked', $( this ).is( ':checked' ) );
		} );

		badgeCheckboxes.on( 'change', function () {
			if ( badgeCheckboxes.length === badgeCheckboxes.filter( ':checked' ).length ) {
				selectAll.prop( 'checked', true );
			} else {
				selectAll.prop( 'checked', false );
			}
		} );
	}

	// Bulk actions - form submission
	const bulkForm = $( '#mrb-pb-bulk-form' );
	const bulkActionSelect = $( '#mrb-pb-bulk-action' );
	const doBulkAction = $( '#mrb-pb-do-bulk-action' );

	if ( bulkForm.length && bulkActionSelect.length && doBulkAction.length ) {
		doBulkAction.on( 'click', function ( e ) {
			const action = bulkActionSelect.val();

			if ( ! action ) {
				e.preventDefault();
				alert( MRBPBAdmin?.bulkActionRequired || 'Please select a bulk action.' );
				return false;
			}

			const checked = badgeCheckboxes.filter( ':checked' );

			if ( checked.length === 0 ) {
				e.preventDefault();
				alert( MRBPBAdmin?.noBadgesSelected || 'Please select at least one badge.' );
				return false;
			}

			bulkForm.find( 'input[name="mrb_pb_action"]' ).remove();
			bulkForm.append( '<input type="hidden" name="mrb_pb_action" value="' + action + '">' );
		} );
	}
}( jQuery ) );

