/**
 * MrB Promo Badge - Frontend JavaScript
 * Handles responsive behavior and mobile scaling
 */
( function() {
	'use strict';

	function initBadges() {
		const badges = document.querySelectorAll( '.mrb-promo-badge[data-mobile-scale]' );

		if ( ! badges.length ) {
			return;
		}

		// Check if mobile
		const isMobile = window.innerWidth <= 768 || /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test( navigator.userAgent );

		badges.forEach( function( badge ) {
			const mobileScale = parseFloat( badge.getAttribute( 'data-mobile-scale' ) ) || 1;
			const showMobile = badge.getAttribute( 'data-show-mobile' ) === '1';

			// Only apply mobile scale if on mobile and show mobile is enabled
			// CSS handles the show/hide logic via media queries
			if ( isMobile && showMobile && mobileScale !== 1 && mobileScale > 0 ) {
				const placement = badge.classList.contains( 'mrb-promo-badge--top-left' ) ? 'top left' :
				                  badge.classList.contains( 'mrb-promo-badge--top-right' ) ? 'top right' :
				                  badge.classList.contains( 'mrb-promo-badge--bottom-left' ) ? 'bottom left' :
				                  badge.classList.contains( 'mrb-promo-badge--bottom-right' ) ? 'bottom right' :
				                  'top left';

				badge.style.transform = 'scale(' + mobileScale + ')';
				badge.style.transformOrigin = placement;
			} else {
				// Reset transform if not mobile or scale is 1
				badge.style.transform = '';
				badge.style.transformOrigin = '';
			}
		} );
	}

	// Run on DOM ready
	if ( document.readyState === 'loading' ) {
		document.addEventListener( 'DOMContentLoaded', initBadges );
	} else {
		initBadges();
	}

	// Re-run on resize (debounced)
	let resizeTimer;
	window.addEventListener( 'resize', function() {
		clearTimeout( resizeTimer );
		resizeTimer = setTimeout( initBadges, 250 );
	} );
} )();

