<?php
/**
 * Plugin Name: MrB Promo Badge For Products
 * Description: Flexible promo badges for WooCommerce products.
 * Author: Mr.Brabus
 * Version: 1.1.8
 * Text Domain: mrb-promo-badge
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'MRB_PB_PATH', plugin_dir_path( __FILE__ ) );
define( 'MRB_PB_URL', plugin_dir_url( __FILE__ ) );
define( 'MRB_PB_VERSION', '1.1.8' );

require MRB_PB_PATH . 'src/Autoloader.php';

MrB\PromoBadge\Autoloader::init();

function mrb_promo_badge() {
    static $plugin = null;

    if ( $plugin === null ) {
        $plugin = new MrB\PromoBadge\Plugin();
    }

    return $plugin;
}

add_action( 'plugins_loaded', function () {
    mrb_promo_badge()->boot();
} );
