<?php

namespace MrB\PromoBadge;

class Autoloader {

    public static function init() {
        spl_autoload_register( [ __CLASS__, 'autoload' ] );
    }

    public static function autoload( $class ) {
        $prefix = __NAMESPACE__ . '\\';

        // ignorisi druge namespace-ove
        if ( strpos( $class, $prefix ) !== 0 ) {
            return;
        }

        // skini prefix
        $relative = substr( $class, strlen( $prefix ) );
        // zameni \ sa /
        $relative = str_replace( '\\', DIRECTORY_SEPARATOR, $relative );

        $file = __DIR__ . DIRECTORY_SEPARATOR . $relative . '.php';

        if ( file_exists( $file ) ) {
            require $file;
        }
    }
}
