<?php

namespace MrB\PromoBadge\Model;

abstract class Badge_Design {

    protected $border;
    protected $border_radius;
    protected $background_color;
    protected $use_background;
    protected $padding;
    protected $offset_x;
    protected $offset_y;
    protected $z_index;

    public function __construct( array $styles = [] ) {
        $this->border           = $styles['border'] ?? '';
        $this->border_radius    = $styles['border_radius'] ?? '';
        $this->background_color = $styles['background_color'] ?? '';
        $this->use_background   = ! empty( $styles['use_background'] );
        $this->padding          = $styles['padding'] ?? '';
        $this->offset_x         = (float) ( $styles['offset_x'] ?? 0 );
        $this->offset_y         = (float) ( $styles['offset_y'] ?? 0 );
        $this->z_index          = (int) ( $styles['z_index'] ?? 10 );
    }

    abstract public function get_type() : string;

    public function get_border() : string { return $this->border; }
    public function get_border_radius() : string { return $this->border_radius; }
    public function get_background_color() : string { return $this->background_color; }
    public function get_use_background() : bool { return $this->use_background; }
    public function get_padding() : string { return $this->padding; }
    public function get_offset_x() : float { return $this->offset_x; }
    public function get_offset_y() : float { return $this->offset_y; }
    public function get_z_index() : int { return $this->z_index; }
}
