<?php

namespace MrB\PromoBadge\Model;

class Image_Badge_Design extends Badge_Design {

    protected $image_id;
    protected $width;
    protected $height;
    protected $object_fit;
    protected $image_url;

    public function __construct( array $data ) {
        parent::__construct( $data['styles'] ?? [] );

        $this->image_id   = (int) ( $data['image_id'] ?? 0 );
        $this->image_url  = $data['image_url'] ?? '';
        $this->width      = $data['width'] ?? '';
        $this->height     = $data['height'] ?? '';
        $this->object_fit = $data['object_fit'] ?? 'contain';
    }

    public function get_type() : string {
        return 'image';
    }

    public function get_image_id() : int { return $this->image_id; }
    public function get_image_url() : string { return $this->image_url; }
    public function get_width() : string { return $this->width; }
    public function get_height() : string { return $this->height; }
    public function get_object_fit() : string { return $this->object_fit; }
}
