<?php

namespace MrB\PromoBadge\Model;

use MrB\PromoBadge\Rules\Rule_Interface;
use MrB\PromoBadge\Services\Product_Context;

class Promo_Set {

    protected $id;
    protected $name;
    protected $design;          // Badge_Design
    protected $rule;            // Rule_Interface
    protected $placement;       // Placement
    protected $responsive;      // Responsive_Settings
    protected $priority;
    protected $enabled;

    public function __construct(
        $id,
        string $name,
        Badge_Design $design,
        Rule_Interface $rule,
        Placement $placement,
        Responsive_Settings $responsive,
        int $priority = 10,
        bool $enabled = true
    ) {
        $this->id         = $id;
        $this->name       = $name;
        $this->design     = $design;
        $this->rule       = $rule;
        $this->placement  = $placement;
        $this->responsive = $responsive;
        $this->priority   = $priority;
        $this->enabled    = $enabled;
    }

    public function get_id() {
        return $this->id;
    }

    public function get_name() : string {
        return $this->name;
    }

    public function get_design() : Badge_Design {
        return $this->design;
    }

    public function get_rule() : Rule_Interface {
        return $this->rule;
    }

    public function get_placement() : Placement {
        return $this->placement;
    }

    public function get_responsive() : Responsive_Settings {
        return $this->responsive;
    }

    public function get_priority() : int {
        return $this->priority;
    }

    public function is_enabled() : bool {
        return $this->enabled;
    }

    public function matches( Product_Context $context ) : bool {
        if ( ! $this->enabled ) {
            return false;
        }

        return $this->rule->matches( $context );
    }
}
