<?php

namespace MrB\PromoBadge\Model;

class Responsive_Settings {

    protected $show_on_desktop;
    protected $show_on_mobile;
    protected $mobile_scale;
    protected $custom_css_desktop;
    protected $custom_css_tablet;
    protected $custom_css_mobile;

    public function __construct( 
        bool $show_on_desktop, 
        bool $show_on_mobile, 
        float $mobile_scale = 1.0,
        string $custom_css_desktop = '',
        string $custom_css_tablet = '',
        string $custom_css_mobile = ''
    ) {
        $this->show_on_desktop = $show_on_desktop;
        $this->show_on_mobile  = $show_on_mobile;
        $this->mobile_scale    = $mobile_scale;
        $this->custom_css_desktop = $custom_css_desktop;
        $this->custom_css_tablet = $custom_css_tablet;
        $this->custom_css_mobile = $custom_css_mobile;
    }

    public function should_show_on( string $device ) : bool {
        if ( $device === 'mobile' ) {
            return $this->show_on_mobile;
        }

        return $this->show_on_desktop;
    }

    public function get_mobile_scale() : float {
        return $this->mobile_scale;
    }

    public function get_custom_css_desktop() : string {
        return $this->custom_css_desktop;
    }

    public function get_custom_css_tablet() : string {
        return $this->custom_css_tablet;
    }

    public function get_custom_css_mobile() : string {
        return $this->custom_css_mobile;
    }
}
