<?php

namespace MrB\PromoBadge\Model;

class Text_Badge_Design extends Badge_Design {

    protected $text;
    protected $text_color;
    protected $font_family;
    protected $font_weight;
    protected $font_size;

    public function __construct( array $data ) {
        parent::__construct( $data['styles'] ?? [] );

        $this->text        = $data['text'] ?? '';
        $this->text_color  = $data['text_color'] ?? '#ffffff';
        $this->font_family = $data['font_family'] ?? '';
        $this->font_weight = $data['font_weight'] ?? '600';
        $this->font_size   = $data['font_size'] ?? '12px';
    }

    public function get_type() : string {
        return 'text';
    }

    public function get_text() : string { return $this->text; }
    public function get_text_color() : string { return $this->text_color; }
    public function get_font_family() : string { return $this->font_family; }
    public function get_font_weight() : string { return $this->font_weight; }
    public function get_font_size() : string { return $this->font_size; }
}
