<?php

namespace MrB\PromoBadge;

use MrB\PromoBadge\Admin\Admin_Service_Provider;
use MrB\PromoBadge\Frontend\Frontend_Service_Provider;
use MrB\PromoBadge\Repository\Promo_Set_Option_Repository;
use MrB\PromoBadge\Services\Promo_Set_Manager;
use MrB\PromoBadge\Update\Update_Checker;

class Plugin {

    protected $promo_set_repository;
    protected $promo_set_manager;

    public function __construct() {
        $this->promo_set_repository = new Promo_Set_Option_Repository();
        $this->promo_set_manager    = new Promo_Set_Manager( $this->promo_set_repository );
    }

    public function boot() {
        // Update checker - uvek se registruje
        new Update_Checker();

        if ( ! function_exists( 'WC' ) ) {
            // WooCommerce nije aktivan, npr. možemo kasnije dodati admin notice
            return;
        }

        if ( is_admin() ) {
            ( new Admin_Service_Provider( $this->promo_set_repository ) )->register();
        }

        ( new Frontend_Service_Provider( $this->promo_set_manager ) )->register();
    }

    public function promo_sets() : Promo_Set_Manager {
        return $this->promo_set_manager;
    }
}
