<?php

namespace MrB\PromoBadge\Repository;

use MrB\PromoBadge\Model\Promo_Set;

class Promo_Set_CPT_Repository implements Promo_Set_Repository_Interface {

    const CPT = 'mrb_promo_set';

    public function __construct() {
        add_action( 'init', [ $this, 'register_cpt' ] );
    }

    public function register_cpt() {
        register_post_type( self::CPT, [
            'label'           => __( 'Promo Sets', 'mrb-promo-badge' ),
            'public'          => false,
            'show_ui'         => true,
            'show_in_menu'    => true,
            'supports'        => [ 'title' ],
            'capability_type' => 'post',
            'menu_position'   => 25,
        ] );
    }

    public function all_enabled() : array {
        // TODO: procitati sve objave ovog CPT-a + meta i mapirati u Promo_Set modele
        return [];
    }

    public function find( $id ) : ?Promo_Set {
        // TODO
        return null;
    }

    public function save( Promo_Set $set ) : int {
        // TODO
        return 0;
    }
}
