<?php

namespace MrB\PromoBadge\Rules;

use MrB\PromoBadge\Services\Product_Context;

class Brand_Rule implements Rule_Interface {

	protected $brand_ids;

	public function __construct( array $brand_ids ) {
		$this->brand_ids = array_map( 'intval', $brand_ids );
	}

	public function matches( Product_Context $context ) : bool {
		$product = $context->get_product();

		if ( ! $product ) {
			return false;
		}

		// Try different brand taxonomy names (same order as in template)
		$brand_taxonomies = [ 'product_brand', 'pwb-brand', 'pa_brand', 'yith_product_brand' ];

		foreach ( $brand_taxonomies as $taxonomy ) {
			if ( ! taxonomy_exists( $taxonomy ) ) {
				continue;
			}

			$terms = wp_get_post_terms( $product->get_id(), $taxonomy, [ 'fields' => 'ids' ] );

			if ( is_wp_error( $terms ) || empty( $terms ) ) {
				continue;
			}

			if ( array_intersect( $this->brand_ids, $terms ) ) {
				return true;
			}
		}

		return false;
	}
}

