<?php

namespace MrB\PromoBadge\Rules;

use MrB\PromoBadge\Services\Product_Context;

class Category_Rule implements Rule_Interface {

    protected $category_ids;

    public function __construct( array $category_ids ) {
        $this->category_ids = array_map( 'intval', $category_ids );
    }

    public function matches( Product_Context $context ) : bool {
        $product = $context->get_product();

        if ( ! $product ) {
            return false;
        }

        $terms = wp_get_post_terms( $product->get_id(), 'product_cat', [ 'fields' => 'ids' ] );

        if ( is_wp_error( $terms ) ) {
            return false;
        }

        return (bool) array_intersect( $this->category_ids, $terms );
    }
}
