<?php

namespace MrB\PromoBadge\Rules;

use MrB\PromoBadge\Services\Product_Context;

class Composite_Rule implements Rule_Interface {

    const TYPE_AND = 'AND';
    const TYPE_OR  = 'OR';

    /** @var Rule_Interface[] */
    protected $rules;
    protected $type;

    public function __construct( array $rules, string $type = self::TYPE_AND ) {
        $this->rules = $rules;
        $this->type  = $type;
    }

    public function matches( Product_Context $context ) : bool {
        if ( $this->type === self::TYPE_AND ) {
            foreach ( $this->rules as $rule ) {
                if ( ! $rule->matches( $context ) ) {
                    return false;
                }
            }

            return true;
        }

        foreach ( $this->rules as $rule ) {
            if ( $rule->matches( $context ) ) {
                return true;
            }
        }

        return false;
    }
}
