<?php

namespace MrB\PromoBadge\Rules;

use MrB\PromoBadge\Services\Product_Context;

class Tag_Rule implements Rule_Interface {

    protected $tag_ids;

    public function __construct( array $tag_ids ) {
        $this->tag_ids = array_map( 'intval', $tag_ids );
    }

    public function matches( Product_Context $context ) : bool {
        $product = $context->get_product();

        if ( ! $product ) {
            return false;
        }

        $terms = wp_get_post_terms( $product->get_id(), 'product_tag', [ 'fields' => 'ids' ] );

        if ( is_wp_error( $terms ) ) {
            return false;
        }

        return (bool) array_intersect( $this->tag_ids, $terms );
    }
}
