<?php

namespace MrB\PromoBadge\Services;

use MrB\PromoBadge\Repository\Promo_Set_Repository_Interface;
use MrB\PromoBadge\Model\Promo_Set;

class Promo_Set_Manager {

    protected $repo;

    public function __construct( Promo_Set_Repository_Interface $repo ) {
        $this->repo = $repo;
    }

    /**
     * Vrati jedan (ili više) odgovarajućih setova.
     *
     * @param bool $multiple da li želimo sve ili samo prvi koji se poklapa
     * @return Promo_Set[]|Promo_Set|null
     */
    public function get_matching_sets( Product_Context $context, bool $multiple = false ) {
        if ( ! $context->is_archive() ) {
            return $multiple ? [] : null;
        }

        $all_sets = $this->repo->all_enabled();

        // sort po prioritetu
        usort( $all_sets, function ( Promo_Set $a, Promo_Set $b ) {
            return $a->get_priority() <=> $b->get_priority();
        } );

        $matches = [];

        foreach ( $all_sets as $set ) {
            if ( ! $set->get_responsive()->should_show_on( $context->get_device() ) ) {
                continue;
            }

            if ( $set->matches( $context ) ) {
                if ( ! $multiple ) {
                    return $set;
                }
                $matches[] = $set;
            }
        }

        return $multiple ? $matches : null;
    }

    /**
     * Get all enabled promo sets
     * 
     * @return Promo_Set[]
     */
    public function get_all_enabled_sets() : array {
        return $this->repo->all_enabled();
    }
}
