<?php
/**
 * @var array $badge
 */
$is_edit  = ! empty( $badge['id'] );
$back_url = admin_url( 'admin.php?page=mrb-promo-badge' );
?>
<div class="wrap mrb-pb-admin">
    <div class="mrb-pb-admin__header">
        <div>
            <h1 class="wp-heading-inline">
                <?php echo esc_html( $is_edit ? __( 'Edit Badge', 'mrb-promo-badge' ) : __( 'Add new badge', 'mrb-promo-badge' ) ); ?>
            </h1>
            <p><?php esc_html_e( 'Design the badge once, then decide where it shows up across your shop grid.', 'mrb-promo-badge' ); ?></p>
        </div>

        <a href="<?php echo esc_url( $back_url ); ?>" class="button button-secondary">
            <?php esc_html_e( 'Back to list', 'mrb-promo-badge' ); ?>
        </a>
    </div>

    <form method="post" class="mrb-pb-editor-form">
        <?php wp_nonce_field( 'mrb_pb_save_badge', 'mrb_pb_nonce' ); ?>
        <input type="hidden" name="mrb_pb_action" value="save_badge">
        <input type="hidden" name="mrb_pb[id]" value="<?php echo esc_attr( $badge['id'] ?? '' ); ?>">

        <div class="mrb-pb-editor-layout">
            <div class="mrb-pb-editor-main">
                <section class="mrb-pb-panel">
                    <div class="mrb-pb-panel__header">
                        <div>
                            <div class="mrb-pb-panel__title"><?php esc_html_e( 'Badge basics', 'mrb-promo-badge' ); ?></div>
                            <p class="mrb-pb-panel__description"><?php esc_html_e( 'Enable the badge, name it and define its base behaviour.', 'mrb-promo-badge' ); ?></p>
                        </div>
                    </div>

                    <div class="mrb-pb-panel__grid">
                        <label class="mrb-pb-form-row mrb-pb-toggle">
                            <input type="checkbox" name="mrb_pb[enabled]" value="1" <?php checked( $badge['enabled'] ?? false, true ); ?>>
                            <span><?php esc_html_e( 'Badge enabled', 'mrb-promo-badge' ); ?></span>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Label', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[name]" value="<?php echo esc_attr( $badge['name'] ?? '' ); ?>" class="regular-text">
                            <small><?php esc_html_e( 'Internal only — helps you recognise this badge later.', 'mrb-promo-badge' ); ?></small>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Badge type', 'mrb-promo-badge' ); ?></span>
                            <select name="mrb_pb[type]" id="mrb-pb-type">
                                <option value="text" <?php selected( $badge['type'] ?? 'text', 'text' ); ?>><?php esc_html_e( 'Text badge', 'mrb-promo-badge' ); ?></option>
                                <option value="image" <?php selected( $badge['type'] ?? 'text', 'image' ); ?>><?php esc_html_e( 'Image badge', 'mrb-promo-badge' ); ?></option>
                            </select>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Placement', 'mrb-promo-badge' ); ?></span>
                            <select name="mrb_pb[placement]">
                                <?php
                                $positions = [
                                    'top-left'     => __( 'Top Left', 'mrb-promo-badge' ),
                                    'top-right'    => __( 'Top Right', 'mrb-promo-badge' ),
                                    'bottom-left'  => __( 'Bottom Left', 'mrb-promo-badge' ),
                                    'bottom-right' => __( 'Bottom Right', 'mrb-promo-badge' ),
                                ];
                                foreach ( $positions as $value => $label ) :
                                    ?>
                                    <option value="<?php echo esc_attr( $value ); ?>" <?php selected( $badge['placement'] ?? 'top-left', $value ); ?>>
                                        <?php echo esc_html( $label ); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Priority (lower shows first)', 'mrb-promo-badge' ); ?></span>
                            <input type="number" name="mrb_pb[priority]" value="<?php echo esc_attr( $badge['priority'] ?? 10 ); ?>" min="0" step="1">
                        </label>
                    </div>
                </section>

                <section class="mrb-pb-panel">
                    <div class="mrb-pb-panel__header">
                        <div>
                            <div class="mrb-pb-panel__title"><?php esc_html_e( 'Targeting rules', 'mrb-promo-badge' ); ?></div>
                            <p class="mrb-pb-panel__description"><?php esc_html_e( 'Choose which products should display this badge. Leave all unchecked to show on all products.', 'mrb-promo-badge' ); ?></p>
                        </div>
                    </div>

                    <div class="mrb-pb-panel__grid">
                        <label class="mrb-pb-form-row mrb-pb-toggle">
                            <input type="checkbox" name="mrb_pb[rules][on_sale]" value="1" <?php checked( ! empty( $badge['rules']['on_sale'] ), true ); ?>>
                            <span><?php esc_html_e( 'Products on sale', 'mrb-promo-badge' ); ?></span>
                        </label>

                        <div class="mrb-pb-form-row mrb-pb-form-row--full">
                            <label>
                                <span><?php esc_html_e( 'Product categories', 'mrb-promo-badge' ); ?></span>
                                <select name="mrb_pb[rules][category_ids][]" multiple class="mrb-pb-multiselect" size="6">
                                    <?php
                                    $categories = get_terms( [
                                        'taxonomy'   => 'product_cat',
                                        'hide_empty' => false,
                                    ] );

                                    $selected_cats = $badge['rules']['category_ids'] ?? [];
                                    // Ensure selected_cats is array and convert to integers for comparison
                                    if ( ! is_array( $selected_cats ) ) {
                                        $selected_cats = [];
                                    }
                                    $selected_cats = array_map( 'intval', $selected_cats );

                                    if ( ! is_wp_error( $categories ) ) :
                                        foreach ( $categories as $cat ) :
                                            ?>
                                            <option value="<?php echo esc_attr( $cat->term_id ); ?>" <?php selected( in_array( (int) $cat->term_id, $selected_cats, true ), true ); ?>>
                                                <?php echo esc_html( $cat->name ); ?>
                                            </option>
                                        <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </select>
                                <small><?php esc_html_e( 'Hold Ctrl/Cmd to select multiple', 'mrb-promo-badge' ); ?></small>
                            </label>
                        </div>

                        <div class="mrb-pb-form-row mrb-pb-form-row--full">
                            <label>
                                <span><?php esc_html_e( 'Product tags', 'mrb-promo-badge' ); ?></span>
                                <select name="mrb_pb[rules][tag_ids][]" multiple class="mrb-pb-multiselect" size="6">
                                    <?php
                                    $tags = get_terms( [
                                        'taxonomy'   => 'product_tag',
                                        'hide_empty' => false,
                                    ] );

                                    $selected_tags = $badge['rules']['tag_ids'] ?? [];
                                    // Ensure selected_tags is array and convert to integers for comparison
                                    if ( ! is_array( $selected_tags ) ) {
                                        $selected_tags = [];
                                    }
                                    $selected_tags = array_map( 'intval', $selected_tags );

                                    if ( ! is_wp_error( $tags ) ) :
                                        foreach ( $tags as $tag ) :
                                            ?>
                                            <option value="<?php echo esc_attr( $tag->term_id ); ?>" <?php selected( in_array( (int) $tag->term_id, $selected_tags, true ), true ); ?>>
                                                <?php echo esc_html( $tag->name ); ?>
                                            </option>
                                        <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </select>
                                <small><?php esc_html_e( 'Hold Ctrl/Cmd to select multiple', 'mrb-promo-badge' ); ?></small>
                            </label>
                        </div>

                        <div class="mrb-pb-form-row mrb-pb-form-row--full">
                            <label>
                                <span><?php esc_html_e( 'Product brands', 'mrb-promo-badge' ); ?></span>
                                <select name="mrb_pb[rules][brand_ids][]" multiple class="mrb-pb-multiselect" size="6">
                                    <?php
                                    // Try different brand taxonomy names
                                    $brand_taxonomies = [ 'product_brand', 'pwb-brand', 'pa_brand', 'yith_product_brand' ];
                                    $brands = [];
                                    $brand_taxonomy = '';

                                    foreach ( $brand_taxonomies as $taxonomy ) {
                                        if ( taxonomy_exists( $taxonomy ) ) {
                                            $brand_taxonomy = $taxonomy;
                                            $brands = get_terms( [
                                                'taxonomy'   => $taxonomy,
                                                'hide_empty' => false,
                                            ] );
                                            break;
                                        }
                                    }

                                    $selected_brands = $badge['rules']['brand_ids'] ?? [];
                                    // Ensure selected_brands is array and convert to integers for comparison
                                    if ( ! is_array( $selected_brands ) ) {
                                        $selected_brands = [];
                                    }
                                    $selected_brands = array_map( 'intval', $selected_brands );

                                    if ( ! is_wp_error( $brands ) && ! empty( $brands ) ) :
                                        foreach ( $brands as $brand ) :
                                            ?>
                                            <option value="<?php echo esc_attr( $brand->term_id ); ?>" <?php selected( in_array( (int) $brand->term_id, $selected_brands, true ), true ); ?>>
                                                <?php echo esc_html( $brand->name ); ?>
                                            </option>
                                        <?php
                                        endforeach;
                                    else :
                                        ?>
                                        <option disabled><?php esc_html_e( 'No brands found. Make sure you have a brand taxonomy set up.', 'mrb-promo-badge' ); ?></option>
                                    <?php
                                    endif;
                                    ?>
                                </select>
                                <small><?php esc_html_e( 'Hold Ctrl/Cmd to select multiple', 'mrb-promo-badge' ); ?></small>
                            </label>
                        </div>

                        <div class="mrb-pb-form-row mrb-pb-form-row--full">
                            <label>
                                <span><?php esc_html_e( 'Rule logic', 'mrb-promo-badge' ); ?></span>
                                <select name="mrb_pb[rules][logic]">
                                    <option value="or" <?php selected( ( $badge['rules']['logic'] ?? 'or' ), 'or' ); ?>>
                                        <?php esc_html_e( 'OR - Show if any rule matches', 'mrb-promo-badge' ); ?>
                                    </option>
                                    <option value="and" <?php selected( ( $badge['rules']['logic'] ?? 'or' ), 'and' ); ?>>
                                        <?php esc_html_e( 'AND - Show if all rules match', 'mrb-promo-badge' ); ?>
                                    </option>
                                </select>
                            </label>
                        </div>
                    </div>
                </section>

                <section class="mrb-pb-panel mrb-pb-fieldset mrb-pb-fieldset--text" data-type="text">
                    <div class="mrb-pb-panel__header">
                        <div>
                            <div class="mrb-pb-panel__title"><?php esc_html_e( 'Text badge content', 'mrb-promo-badge' ); ?></div>
                            <p class="mrb-pb-panel__description"><?php esc_html_e( 'Typography settings apply only when badge type is “Text”.', 'mrb-promo-badge' ); ?></p>
                        </div>
                    </div>

                    <div class="mrb-pb-panel__grid">
                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Badge text', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][text]" value="<?php echo esc_attr( $badge['design']['text'] ?? '' ); ?>" class="regular-text">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Text color', 'mrb-promo-badge' ); ?></span>
                            <input type="text" class="mrb-pb-color-field" name="mrb_pb[design][text_color]" value="<?php echo esc_attr( $badge['design']['text_color'] ?? '#ffffff' ); ?>">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Font family', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][font_family]" value="<?php echo esc_attr( $badge['design']['font_family'] ?? '' ); ?>" class="regular-text">
                            <small><?php esc_html_e( 'Leave empty to inherit WooCommerce typography.', 'mrb-promo-badge' ); ?></small>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Font weight', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][font_weight]" value="<?php echo esc_attr( $badge['design']['font_weight'] ?? '600' ); ?>" class="regular-text">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Font size', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][font_size]" value="<?php echo esc_attr( $badge['design']['font_size'] ?? '14px' ); ?>" class="regular-text">
                        </label>
                    </div>
                </section>

                <section class="mrb-pb-panel mrb-pb-fieldset mrb-pb-fieldset--image" data-type="image">
                    <div class="mrb-pb-panel__header">
                        <div>
                            <div class="mrb-pb-panel__title"><?php esc_html_e( 'Image badge', 'mrb-promo-badge' ); ?></div>
                            <p class="mrb-pb-panel__description"><?php esc_html_e( 'Upload a PNG/SVG or paste an external URL for badge artwork.', 'mrb-promo-badge' ); ?></p>
                        </div>
                    </div>

                    <div class="mrb-pb-panel__grid">
                        <div class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Badge artwork', 'mrb-promo-badge' ); ?></span>
                            <div class="mrb-pb-media">
                                <input type="hidden" name="mrb_pb[design][image_id]" id="mrb-pb-image-id" value="<?php echo esc_attr( $badge['design']['image_id'] ?? 0 ); ?>">
                                <div class="mrb-pb-media__preview" id="mrb-pb-image-preview">
                                    <?php if ( ! empty( $badge['design']['image_id'] ) ) : ?>
                                        <?php echo wp_get_attachment_image( $badge['design']['image_id'], 'thumbnail' ); ?>
                                    <?php elseif ( ! empty( $badge['design']['image_url'] ) ) : ?>
                                        <img src="<?php echo esc_url( $badge['design']['image_url'] ); ?>" alt="" />
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <button type="button" class="button button-secondary mrb-pb-media__select" id="mrb-pb-select-image">
                                        <?php esc_html_e( 'Select image', 'mrb-promo-badge' ); ?>
                                    </button>
                                    <button type="button" class="button button-link-delete mrb-pb-media__remove" id="mrb-pb-remove-image">
                                        <?php esc_html_e( 'Remove', 'mrb-promo-badge' ); ?>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Fallback image URL', 'mrb-promo-badge' ); ?></span>
                            <input type="url" name="mrb_pb[design][image_url]" id="mrb-pb-image-url" value="<?php echo esc_attr( $badge['design']['image_url'] ?? '' ); ?>" class="regular-text">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Width', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][width]" value="<?php echo esc_attr( $badge['design']['width'] ?? '72px' ); ?>" class="regular-text">
                            <small><?php esc_html_e( 'Example: 80px or 5rem.', 'mrb-promo-badge' ); ?></small>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Height', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][height]" value="<?php echo esc_attr( $badge['design']['height'] ?? '72px' ); ?>" class="regular-text">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Object fit', 'mrb-promo-badge' ); ?></span>
                            <select name="mrb_pb[design][object_fit]">
                                <?php foreach ( [ 'contain', 'cover', 'fill' ] as $fit ) : ?>
                                    <option value="<?php echo esc_attr( $fit ); ?>" <?php selected( $badge['design']['object_fit'] ?? 'contain', $fit ); ?>>
                                        <?php echo esc_html( ucfirst( $fit ) ); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </label>
                    </div>
                </section>

                <section class="mrb-pb-panel">
                    <div class="mrb-pb-panel__header">
                        <div>
                            <div class="mrb-pb-panel__title"><?php esc_html_e( 'Visual styling', 'mrb-promo-badge' ); ?></div>
                            <p class="mrb-pb-panel__description"><?php esc_html_e( 'Shared styles covering both badge types.', 'mrb-promo-badge' ); ?></p>
                        </div>
                    </div>

                    <div class="mrb-pb-panel__grid">
                        <label class="mrb-pb-form-row mrb-pb-toggle">
                            <input type="checkbox" name="mrb_pb[design][styles][use_background]" value="1" <?php checked( ! empty( $badge['design']['styles']['use_background'] ), true ); ?>>
                            <span><?php esc_html_e( 'Use background color', 'mrb-promo-badge' ); ?></span>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Background color', 'mrb-promo-badge' ); ?></span>
                            <input type="text" class="mrb-pb-color-field" name="mrb_pb[design][styles][background_color]" value="<?php echo esc_attr( $badge['design']['styles']['background_color'] ?? '#111111' ); ?>">
                            <small><?php esc_html_e( 'Only applied if "Use background color" is checked', 'mrb-promo-badge' ); ?></small>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Border (CSS shorthand)', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][styles][border]" value="<?php echo esc_attr( $badge['design']['styles']['border'] ?? '' ); ?>" class="regular-text">
                            <small><?php esc_html_e( 'Example: 1px solid rgba(255,255,255,0.2)', 'mrb-promo-badge' ); ?></small>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Border radius', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][styles][border_radius]" value="<?php echo esc_attr( $badge['design']['styles']['border_radius'] ?? '999px' ); ?>" class="regular-text">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Padding', 'mrb-promo-badge' ); ?></span>
                            <input type="text" name="mrb_pb[design][styles][padding]" value="<?php echo esc_attr( $badge['design']['styles']['padding'] ?? '0.45rem 0.9rem' ); ?>" class="regular-text">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Offset X (px)', 'mrb-promo-badge' ); ?></span>
                            <input type="number" name="mrb_pb[design][styles][offset_x]" value="<?php echo esc_attr( $badge['design']['styles']['offset_x'] ?? 12 ); ?>" class="small-text">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Offset Y (px)', 'mrb-promo-badge' ); ?></span>
                            <input type="number" name="mrb_pb[design][styles][offset_y]" value="<?php echo esc_attr( $badge['design']['styles']['offset_y'] ?? 12 ); ?>" class="small-text">
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Z-index', 'mrb-promo-badge' ); ?></span>
                            <input type="number" name="mrb_pb[design][styles][z_index]" value="<?php echo esc_attr( $badge['design']['styles']['z_index'] ?? 15 ); ?>" class="small-text">
                        </label>
                    </div>
                </section>

                <section class="mrb-pb-panel">
                    <div class="mrb-pb-panel__header">
                        <div>
                            <div class="mrb-pb-panel__title"><?php esc_html_e( 'Responsive behaviour', 'mrb-promo-badge' ); ?></div>
                            <p class="mrb-pb-panel__description"><?php esc_html_e( 'Switch badges off per device or scale them down on mobile.', 'mrb-promo-badge' ); ?></p>
                        </div>
                    </div>

                    <div class="mrb-pb-panel__grid">
                        <label class="mrb-pb-form-row mrb-pb-toggle">
                            <input type="checkbox" name="mrb_pb[responsive][show_on_desktop]" value="1" <?php checked( $badge['responsive']['show_on_desktop'] ?? true, true ); ?>>
                            <span><?php esc_html_e( 'Show on desktop', 'mrb-promo-badge' ); ?></span>
                        </label>

                        <label class="mrb-pb-form-row mrb-pb-toggle">
                            <input type="checkbox" name="mrb_pb[responsive][show_on_mobile]" value="1" <?php checked( $badge['responsive']['show_on_mobile'] ?? true, true ); ?>>
                            <span><?php esc_html_e( 'Show on mobile', 'mrb-promo-badge' ); ?></span>
                        </label>

                        <label class="mrb-pb-form-row">
                            <span><?php esc_html_e( 'Mobile scale multiplier', 'mrb-promo-badge' ); ?></span>
                            <input type="number" name="mrb_pb[responsive][mobile_scale]" value="<?php echo esc_attr( $badge['responsive']['mobile_scale'] ?? 1 ); ?>" step="0.05" min="0.1">
                            <small><?php esc_html_e( 'Example: 0.85 makes the badge 15% smaller on phones.', 'mrb-promo-badge' ); ?></small>
                        </label>
                    </div>
                </section>

                <section class="mrb-pb-panel">
                    <div class="mrb-pb-panel__header">
                        <div>
                            <div class="mrb-pb-panel__title"><?php esc_html_e( 'Custom CSS', 'mrb-promo-badge' ); ?></div>
                            <p class="mrb-pb-panel__description"><?php esc_html_e( 'Add custom CSS for fine-tuning badge appearance on different devices. CSS is automatically scoped to this badge only.', 'mrb-promo-badge' ); ?></p>
                        </div>
                    </div>

                    <div class="mrb-pb-panel__grid">
                        <div class="mrb-pb-form-row mrb-pb-form-row--full">
                            <label>
                                <span><?php esc_html_e( 'Desktop CSS (min-width: 769px)', 'mrb-promo-badge' ); ?></span>
                                <textarea name="mrb_pb[responsive][custom_css_desktop]" rows="6" class="large-text code" placeholder="<?php esc_attr_e( '/* Example: */&#10;transform: rotate(-5deg);&#10;box-shadow: 0 4px 8px rgba(0,0,0,0.2);', 'mrb-promo-badge' ); ?>"><?php echo esc_textarea( $badge['responsive']['custom_css_desktop'] ?? '' ); ?></textarea>
                                <small>
                                    <?php esc_html_e( 'Target the badge using:', 'mrb-promo-badge' ); ?>
                                    <code>.mrb-promo-badge</code>
                                    <?php esc_html_e( 'or', 'mrb-promo-badge' ); ?>
                                    <code>.mrb-promo-badge__img</code>
                                    <?php esc_html_e( 'for image badges.', 'mrb-promo-badge' ); ?>
                                </small>
                            </label>
                        </div>

                        <div class="mrb-pb-form-row mrb-pb-form-row--full">
                            <label>
                                <span><?php esc_html_e( 'Tablet CSS (481px - 768px)', 'mrb-promo-badge' ); ?></span>
                                <textarea name="mrb_pb[responsive][custom_css_tablet]" rows="6" class="large-text code" placeholder="<?php esc_attr_e( '/* Example: */&#10;top: 8px !important;&#10;left: 8px !important;&#10;width: 60px;', 'mrb-promo-badge' ); ?>"><?php echo esc_textarea( $badge['responsive']['custom_css_tablet'] ?? '' ); ?></textarea>
                                <small>
                                    <?php esc_html_e( 'Useful for adjusting position, size, or transforms on tablets.', 'mrb-promo-badge' ); ?>
                                </small>
                            </label>
                        </div>

                        <div class="mrb-pb-form-row mrb-pb-form-row--full">
                            <label>
                                <span><?php esc_html_e( 'Mobile CSS (max-width: 480px)', 'mrb-promo-badge' ); ?></span>
                                <textarea name="mrb_pb[responsive][custom_css_mobile]" rows="6" class="large-text code" placeholder="<?php esc_attr_e( '/* Example: */&#10;top: 5px !important;&#10;right: 5px !important;&#10;transform: scale(0.8);', 'mrb-promo-badge' ); ?>"><?php echo esc_textarea( $badge['responsive']['custom_css_mobile'] ?? '' ); ?></textarea>
                                <small>
                                    <?php esc_html_e( 'Perfect for mobile-specific positioning and sizing adjustments.', 'mrb-promo-badge' ); ?>
                                </small>
                            </label>
                        </div>

                        <div class="mrb-pb-form-row mrb-pb-form-row--full">
                            <details style="margin-top: 10px;">
                                <summary style="cursor: pointer; font-weight: 600; color: #2271b1; margin-bottom: 10px;">
                                    <?php esc_html_e( '📖 CSS Examples & Tips', 'mrb-promo-badge' ); ?>
                                </summary>
                                <div style="background: #f6f7f7; padding: 15px; border-radius: 4px; margin-top: 10px; font-size: 13px; line-height: 1.6;">
                                    <p style="margin-top: 0; margin-bottom: 10px;"><strong><?php esc_html_e( 'How it works:', 'mrb-promo-badge' ); ?></strong></p>
                                    <p style="margin: 0 0 15px 0; color: #50575e;">
                                        <?php esc_html_e( 'CSS you enter here is automatically scoped to this specific badge and wrapped in the appropriate media query. You can use either direct CSS properties or target badge classes directly.', 'mrb-promo-badge' ); ?>
                                    </p>

                                    <p style="margin-top: 15px;"><strong><?php esc_html_e( 'Available classes:', 'mrb-promo-badge' ); ?></strong></p>
                                    <ul style="margin: 8px 0; padding-left: 20px;">
                                        <li><code>.mrb-promo-badge</code> - <?php esc_html_e( 'Main badge container', 'mrb-promo-badge' ); ?></li>
                                        <li><code>.mrb-promo-badge__img</code> - <?php esc_html_e( 'Image badge image element', 'mrb-promo-badge' ); ?></li>
                                        <li><code>.mrb-promo-badge__text</code> - <?php esc_html_e( 'Text badge text element', 'mrb-promo-badge' ); ?></li>
                                        <li><code>.mrb-promo-badge--top-left</code>, <code>.mrb-promo-badge--top-right</code>, <code>.mrb-promo-badge--bottom-left</code>, <code>.mrb-promo-badge--bottom-right</code> - <?php esc_html_e( 'Position modifier classes', 'mrb-promo-badge' ); ?></li>
                                    </ul>
                                    
                                    <p style="margin-top: 15px;"><strong><?php esc_html_e( 'Method 1: Direct CSS properties (recommended for simple adjustments):', 'mrb-promo-badge' ); ?></strong></p>
                                    <pre style="background: #fff; padding: 10px; border: 1px solid #ddd; border-radius: 3px; overflow-x: auto; font-size: 12px; margin: 8px 0;"><code><?php esc_html_e( '/* These apply directly to the badge container */', 'mrb-promo-badge' ); ?>
top: 5px !important;
left: 5px !important;
transform: scale(0.8);
width: 50px;
height: 50px;</code></pre>
                                    <p style="margin: 5px 0 15px 0; color: #50575e; font-size: 12px;">
                                        <?php esc_html_e( '→ Automatically wrapped as: .mrb-promo-badge[data-badge-id="..."] { ... }', 'mrb-promo-badge' ); ?>
                                    </p>

                                    <p style="margin-top: 15px;"><strong><?php esc_html_e( 'Method 2: Target specific badge classes:', 'mrb-promo-badge' ); ?></strong></p>
                                    <pre style="background: #fff; padding: 10px; border: 1px solid #ddd; border-radius: 3px; overflow-x: auto; font-size: 12px; margin: 8px 0;"><code><?php esc_html_e( '/* Target position-specific badge (e.g., top-right) */', 'mrb-promo-badge' ); ?>
.mrb-promo-badge--top-right {
    top: -10px !important;
    right: -45px !important;
}

<?php esc_html_e( '/* Target image element inside badge */', 'mrb-promo-badge' ); ?>
.mrb-promo-badge__img {
    width: 60px !important;
    height: auto;
    object-fit: cover;
}

<?php esc_html_e( '/* Target text element inside badge */', 'mrb-promo-badge' ); ?>
.mrb-promo-badge__text {
    font-size: 12px !important;
    padding: 4px 8px;
}</code></pre>
                                    <p style="margin: 5px 0 15px 0; color: #50575e; font-size: 12px;">
                                        <?php esc_html_e( '→ Automatically scoped as: .mrb-promo-badge[data-badge-id="..."].mrb-promo-badge--top-right { ... }', 'mrb-promo-badge' ); ?>
                                    </p>

                                    <p style="margin-top: 15px;"><strong><?php esc_html_e( 'Real-world examples:', 'mrb-promo-badge' ); ?></strong></p>
                                    <pre style="background: #fff; padding: 10px; border: 1px solid #ddd; border-radius: 3px; overflow-x: auto; font-size: 12px; margin: 8px 0;"><code><?php esc_html_e( '/* Mobile: Adjust position for top-right badge */', 'mrb-promo-badge' ); ?>
.mrb-promo-badge--top-right {
    top: -10px !important;
    right: -45px !important;
}

<?php esc_html_e( '/* Tablet: Scale down image badge */', 'mrb-promo-badge' ); ?>
.mrb-promo-badge__img {
    width: 50px !important;
    height: 50px !important;
}

<?php esc_html_e( '/* Desktop: Add rotation effect */', 'mrb-promo-badge' ); ?>
transform: rotate(-5deg);
box-shadow: 0 4px 8px rgba(0,0,0,0.2);</code></pre>
                                    
                                    <p style="margin-top: 15px; padding: 10px; background: #fff3cd; border-left: 4px solid #ffb900; margin-bottom: 0;">
                                        <strong><?php esc_html_e( '💡 Important:', 'mrb-promo-badge' ); ?></strong><br>
                                        <?php esc_html_e( '• CSS is automatically scoped to this badge only (won\'t affect other badges)', 'mrb-promo-badge' ); ?><br>
                                        <?php esc_html_e( '• Media queries are automatically added (Desktop: 769px+, Tablet: 481-768px, Mobile: ≤480px)', 'mrb-promo-badge' ); ?><br>
                                        <?php esc_html_e( '• Use !important only when needed to override default styles', 'mrb-promo-badge' ); ?><br>
                                        <?php esc_html_e( '• You can mix both methods in the same field', 'mrb-promo-badge' ); ?>
                                    </p>
                                </div>
                            </details>
                        </div>
                    </div>
                </section>
            </div>

            <aside class="mrb-pb-editor-side">
                <section class="mrb-pb-panel mrb-pb-preview">
                    <span class="mrb-pb-preview__tag"><?php esc_html_e( 'Preview', 'mrb-promo-badge' ); ?></span>
                    <div class="mrb-pb-preview__headline"><?php echo esc_html( $badge['name'] ?? __( 'Promo Badge', 'mrb-promo-badge' ) ); ?></div>
                    <p class="mrb-pb-preview__muted"><?php esc_html_e( 'This is a static preview. Live badges show on WooCommerce archive cards only.', 'mrb-promo-badge' ); ?></p>
                    <div class="mrb-pb-chips">
                        <span class="mrb-pb-chip"><?php esc_html_e( 'Archive loop', 'mrb-promo-badge' ); ?></span>
                        <span class="mrb-pb-chip"><?php echo esc_html( ucfirst( $badge['type'] ?? 'text' ) ); ?></span>
                        <span class="mrb-pb-chip"><?php esc_html_e( 'Shop & categories', 'mrb-promo-badge' ); ?></span>
                    </div>
                </section>

                <section class="mrb-pb-panel mrb-pb-panel--note">
                    <div class="mrb-pb-panel__title"><?php esc_html_e( 'Quick tips', 'mrb-promo-badge' ); ?></div>
                    <ul style="margin: 0; padding-left: 20px; color: #475569; font-size: 13px; line-height: 1.8;">
                        <li><?php esc_html_e( 'Badges appear only on shop archive pages (not single product pages)', 'mrb-promo-badge' ); ?></li>
                        <li><?php esc_html_e( 'Use targeting rules to show badges on specific products', 'mrb-promo-badge' ); ?></li>
                        <li><?php esc_html_e( 'Lower priority badges show first when multiple match', 'mrb-promo-badge' ); ?></li>
                        <li><?php esc_html_e( 'Test on your shop page to see badges in action', 'mrb-promo-badge' ); ?></li>
                    </ul>
                </section>
            </aside>
        </div>

        <p class="submit">
            <button type="submit" class="button button-primary button-hero">
                <?php esc_html_e( 'Save badge', 'mrb-promo-badge' ); ?>
            </button>
        </p>
    </form>
</div>

