<?php
/**
 * @var array $badges
 */
$add_url = admin_url( 'admin.php?page=mrb-promo-badge&action=new' );
?>
<div class="wrap mrb-pb-admin">
    <div class="mrb-pb-admin__header">
        <h1><?php esc_html_e( 'Promo Badges', 'mrb-promo-badge' ); ?></h1>
        <a href="<?php echo esc_url( $add_url ); ?>" class="page-title-action">
            <?php esc_html_e( 'Add new badge', 'mrb-promo-badge' ); ?>
        </a>
    </div>

    <?php if ( empty( $badges ) ) : ?>
        <div class="notice notice-info">
            <p><?php esc_html_e( 'You have no badges yet. Create one to get started.', 'mrb-promo-badge' ); ?></p>
        </div>
    <?php else : ?>
        <form method="post" id="mrb-pb-bulk-form">
            <?php wp_nonce_field( 'mrb_pb_save_badge', 'mrb_pb_nonce' ); ?>
            <div class="tablenav top">
                <div class="alignleft actions bulkactions">
                    <select name="mrb_pb_action" id="mrb-pb-bulk-action">
                        <option value=""><?php esc_html_e( 'Bulk actions', 'mrb-promo-badge' ); ?></option>
                        <option value="bulk_enable"><?php esc_html_e( 'Enable', 'mrb-promo-badge' ); ?></option>
                        <option value="bulk_disable"><?php esc_html_e( 'Disable', 'mrb-promo-badge' ); ?></option>
                    </select>
                    <button type="submit" class="button action" id="mrb-pb-do-bulk-action">
                        <?php esc_html_e( 'Apply', 'mrb-promo-badge' ); ?>
                    </button>
                </div>
            </div>
        <table class="wp-list-table widefat fixed striped">
            <thead>
            <tr>
                <th class="manage-column column-cb check-column">
                    <input type="checkbox" id="mrb-pb-select-all">
                </th>
                <th><?php esc_html_e( 'Name', 'mrb-promo-badge' ); ?></th>
                <th><?php esc_html_e( 'Type', 'mrb-promo-badge' ); ?></th>
                <th><?php esc_html_e( 'Placement', 'mrb-promo-badge' ); ?></th>
                <th><?php esc_html_e( 'Priority', 'mrb-promo-badge' ); ?></th>
                <th><?php esc_html_e( 'Status', 'mrb-promo-badge' ); ?></th>
                <th><?php esc_html_e( 'Actions', 'mrb-promo-badge' ); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ( $badges as $badge ) :
                $edit_url = admin_url( 'admin.php?page=mrb-promo-badge&action=edit&badge=' . urlencode( $badge['id'] ) );
                ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="badge_ids[]" value="<?php echo esc_attr( $badge['id'] ); ?>" class="mrb-pb-badge-checkbox">
                    </th>
                    <td>
                        <strong><?php echo esc_html( $badge['name'] ); ?></strong>
                    </td>
                    <td><?php echo esc_html( ucfirst( $badge['type'] ?? 'text' ) ); ?></td>
                    <td><?php echo esc_html( ucwords( str_replace( '-', ' ', $badge['placement'] ?? 'top-left' ) ) ); ?></td>
                    <td><?php echo esc_html( (int) ( $badge['priority'] ?? 0 ) ); ?></td>
                    <td>
                        <?php if ( ! empty( $badge['enabled'] ) ) : ?>
                            <span class="status-pill status-pill--active"><?php esc_html_e( 'Active', 'mrb-promo-badge' ); ?></span>
                        <?php else : ?>
                            <span class="status-pill status-pill--inactive"><?php esc_html_e( 'Disabled', 'mrb-promo-badge' ); ?></span>
                        <?php endif; ?>
                    </td>
                    <td class="mrb-pb-table__actions">
                        <a class="button button-small" href="<?php echo esc_url( $edit_url ); ?>">
                            <?php esc_html_e( 'Edit', 'mrb-promo-badge' ); ?>
                        </a>
                        <form method="post" class="mrb-pb-inline-form" onsubmit="return confirm('<?php echo esc_js( __( 'Duplicate this badge?', 'mrb-promo-badge' ) ); ?>');">
                            <?php wp_nonce_field( 'mrb_pb_save_badge', 'mrb_pb_nonce' ); ?>
                            <input type="hidden" name="mrb_pb_action" value="duplicate_badge">
                            <input type="hidden" name="badge_id" value="<?php echo esc_attr( $badge['id'] ); ?>">
                            <button type="submit" class="button button-small">
                                <?php esc_html_e( 'Duplicate', 'mrb-promo-badge' ); ?>
                            </button>
                        </form>
                        <form method="post" class="mrb-pb-inline-form" onsubmit="return confirm('<?php echo esc_js( __( 'Delete this badge?', 'mrb-promo-badge' ) ); ?>');">
                            <?php wp_nonce_field( 'mrb_pb_save_badge', 'mrb_pb_nonce' ); ?>
                            <input type="hidden" name="mrb_pb_action" value="delete_badge">
                            <input type="hidden" name="badge_id" value="<?php echo esc_attr( $badge['id'] ); ?>">
                            <button type="submit" class="button button-small button-link-delete">
                                <?php esc_html_e( 'Delete', 'mrb-promo-badge' ); ?>
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        </form>
    <?php endif; ?>
</div>

