<?php
/**
 * MrB Promo Badge Update Server
 * 
 * POSTAVI OVAJ FAJL NA: public_html/mrb_promo_badge/update.php
 * 
 * Ovaj fajl služi kao update endpoint za WordPress plugin.
 * URL: https://the-happytail.com/mrb_promo_badge/update.php
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Konfiguracija
$plugin_slug = 'mrbrabus-promo-badge';
$plugin_file = 'mrbrabus-promo-badge.php';
$current_version = '1.1.2'; // AŽURIRAJ OVU VERZIJU KADA OBJAVIŠ NOVU
$download_url = 'https://the-happytail.com/mrb_promo_badge/mrb-promo-badge.zip';
$requires = '5.0'; // Minimalna WordPress verzija
$tested = '6.4'; // Testirana WordPress verzija

// Provera da li je zahtev za update info
if (isset($_GET['action']) && $_GET['action'] === 'plugin_information') {
    // Detaljne informacije o pluginu
    $response = [
        'name' => 'MrB Promo Badge For Products',
        'slug' => $plugin_slug,
        'version' => $current_version,
        'author' => '<a href="https://the-happytail.com">Mr.Brabus</a>',
        'author_profile' => 'https://the-happytail.com',
        'requires' => $requires,
        'tested' => $tested,
        'requires_php' => '7.4',
        'last_updated' => date('Y-m-d'),
        'homepage' => 'https://the-happytail.com',
        'short_description' => 'Flexible promo badges for WooCommerce products.',
        'sections' => [
            'description' => '<p>Lightweight WooCommerce plugin for creating beautiful product badges. No bloat, just essential features.</p>',
            'changelog' => '<h4>Version ' . $current_version . '</h4><ul><li>Latest updates and improvements</li></ul>',
        ],
        'download_link' => $download_url,
        'banners' => [
            'low' => '',
            'high' => '',
        ],
        'icons' => [
            'default' => '',
        ],
    ];
    
    echo json_encode($response);
    exit;
}

// Provera verzije (za update check)
$response = [
    'slug' => $plugin_slug,
    'plugin' => $plugin_file,
    'new_version' => $current_version,
    'url' => 'https://the-happytail.com',
    'package' => $download_url,
];

// Proveri da li je poslata verzija
if (isset($_GET['version'])) {
    $requested_version = sanitize_text_field($_GET['version']);
    
    // Ako je verzija starija od trenutne, vrati update info
    if (version_compare($requested_version, $current_version, '<')) {
        echo json_encode($response);
    } else {
        // Nema update-a
        echo json_encode(['no_update' => true]);
    }
} else {
    // Vrati trenutnu verziju
    echo json_encode($response);
}

